﻿using System;

namespace CSharpBuch.Kap08
{
  class Aufgabe1
  {
    static void Main(string[] args)
    {
      int anz;

      Lotto5Aus35 lz = new Lotto5Aus35();
      anz = lz.GetAnzahl();
      Console.WriteLine("Die Lottozahlen von 5 aus 35 lauten: ");
      for (int index = 0; index < anz; index++)
        Console.WriteLine(lz.GetLottoZahl(35));

      Console.WriteLine("Sollten Zahlen doppelt gezogen worden sein, versuchen Sie es nächste Woche einfach wieder!");
    }
  }

  public interface ILottoZiehung
  {
    int GetLottoZahl(int maxZahl);
    int GetAnzahl();
  }

  public class Lotto5Aus35 : ILottoZiehung
  {
    private const int maxZahlen = 5;
    private const int maxLottoZahl = 35;
    private Random rd = new Random(DateTime.Now.Millisecond);

    public int GetLottoZahl(int maxZahl)
    {
      if ((maxZahl <= maxLottoZahl) & (maxZahl > 0))
        return rd.Next(maxZahl) + 1;
      else
        return 0;
    }

    public int GetAnzahl()
    {
      return maxZahlen;
    }
  }

  public class Lotto6Aus49 : ILottoZiehung
  {
    private const int maxZahlen = 6;
    private const int maxLottoZahl = 49;

    private Random rd = new Random(DateTime.Now.Millisecond);

    public int GetLottoZahl(int maxZahl)
    {
      if ((maxZahl <= maxLottoZahl) & (maxZahl > 0))
        return rd.Next(maxZahl) + 1;
      else
        return 0;
    }

    public int GetAnzahl()
    {
      return maxZahlen;
    }
  }
}